IF COL_LENGTH('Cbtes_Tipos', 'Flag_Utiliza_Aprob') IS NULL 
	ALTER TABLE Cbtes_Tipos ADD Flag_Utiliza_Aprob TINYINT
GO
----------------------------------------------------------------------------------------------------------------
IF OBJECT_ID(N'Cbtes_Tipos_Aprob_Rangos','U') IS NULL
	CREATE TABLE Cbtes_Tipos_Aprob_Rangos(
		Id_Aprob_Rango				INT IDENTITY(1,1) NOT NULL,
		Id_Tipo_Cbte				CHAR(4) NOT NULL,
		Imp_Desde					DECIMAL(20,2),
		Imp_Hasta					DECIMAL(20,2),
		Cant_Aprob_Min				TINYINT,   --Si tiene 3 aprobadores y cant = 2, con 2 que aprueben alcanza
		Nota						TEXT,
		CONSTRAINT PK_CBTAR_PorID PRIMARY KEY CLUSTERED (	Id_Aprob_Rango )
	)
GO

IF IndexProperty(Object_Id('Cbtes_Tipos_Aprob_Rangos'), 'CBTTAR_PorTip', 'IndexID') IS  NULL
	CREATE INDEX CBTTAR_PorTip ON Cbtes_Tipos_Aprob_Rangos (Id_Tipo_Cbte)
GO

IF OBJECT_ID('FK_CBTTAR_Cbtes_Tipos', 'F') IS NULL
	ALTER TABLE Cbtes_Tipos_Aprob_Rangos  ADD  CONSTRAINT FK_CBTTAR_Cbtes_Tipos FOREIGN KEY(Id_Tipo_Cbte)
	REFERENCES Cbtes_Tipos (Id_Tipo_Cbte)
GO




---------------------------------------------------------------------------------------------------------
IF OBJECT_ID(N'Cbtes_Tipos_Aprob_Usuarios','U') IS NULL
	CREATE TABLE Cbtes_Tipos_Aprob_Usuarios(
		Id_Aprob_Usuario INT IDENTITY(1,1) NOT NULL,
		Id_Aprob_Rango INT NOT NULL,
		Id_Usuario SMALLINT NOT NULL,
	 CONSTRAINT PK_CBTTAU_PorID PRIMARY KEY CLUSTERED ( Id_Aprob_Usuario )
	)
GO


IF IndexProperty(Object_Id('Cbtes_Tipos_Aprob_Usuarios'), 'CBTTAU_PorRan', 'IndexID') IS  NULL
	CREATE INDEX CBTTAU_PorRan ON Cbtes_Tipos_Aprob_Usuarios (Id_Aprob_Rango)
GO

IF OBJECT_ID('FK_CBTTAU_Aprob_Rangos', 'F') IS NULL
	ALTER TABLE Cbtes_Tipos_Aprob_Usuarios  ADD  CONSTRAINT FK_CBTTAU_Aprob_Rangos FOREIGN KEY(Id_Aprob_Rango)
	REFERENCES Cbtes_Tipos_Aprob_Rangos (Id_Aprob_Rango)
GO

IF IndexProperty(Object_Id('Cbtes_Tipos_Aprob_Usuarios'), 'CBTTAU_PorUsu', 'IndexID') IS  NULL
	CREATE INDEX CBTTAU_PorUsu ON Cbtes_Tipos_Aprob_Usuarios (Id_Usuario)
GO

IF OBJECT_ID('FK_CBTTAU_Seg_User', 'F') IS NULL
	ALTER TABLE Cbtes_Tipos_Aprob_Usuarios  ADD  CONSTRAINT FK_CBTTAU_Seg_User FOREIGN KEY(Id_Usuario)
	REFERENCES Seg_User ([No])
GO


---------------------------------------------------------------------------------------------------------
IF OBJECT_ID(N'Cbtes_Tipos_Aprob_Usu_Del','U') IS NULL
	CREATE TABLE Cbtes_Tipos_Aprob_Usu_Del(
		Id_Aprob_Usu_Del INT IDENTITY(1,1) NOT NULL,
		Id_Aprob_Usuario INT NOT NULL,
		Id_Usuario SMALLINT NOT NULL,
		Fecha_Desde DATETIME,
		Fecha_Hasta DATETIME,
	 CONSTRAINT PK_CBTTAUD_PorID PRIMARY KEY CLUSTERED ( Id_Aprob_Usu_Del )
	)
GO

IF IndexProperty(Object_Id('Cbtes_Tipos_Aprob_Usu_Del'), 'CBTTAUD_PorAus', 'IndexID') IS  NULL
	CREATE INDEX CBTTAUD_PorAus ON Cbtes_Tipos_Aprob_Usu_Del (Id_Aprob_Usuario)
GO

IF OBJECT_ID('FK_CBTTAUD_Aprob_Usu', 'F') IS NULL
	ALTER TABLE Cbtes_Tipos_Aprob_Usu_Del  ADD  CONSTRAINT FK_CBTTAUD_Aprob_Usu FOREIGN KEY(Id_Aprob_Usuario)
	REFERENCES Cbtes_Tipos_Aprob_Usuarios (Id_Aprob_Usuario)
GO

IF IndexProperty(Object_Id('Cbtes_Tipos_Aprob_Usu_Del'), 'CBTTAUD_PorUsu', 'IndexID') IS  NULL
	CREATE INDEX CBTTAUD_PorUsu ON Cbtes_Tipos_Aprob_Usu_Del (Id_Usuario)
GO

IF OBJECT_ID('FK_CBTTAU_Seg_User', 'F') IS NULL
	ALTER TABLE Cbtes_Tipos_Aprob_Usu_Del  ADD  CONSTRAINT FK_CBTTAU_Seg_User FOREIGN KEY(Id_Usuario)
	REFERENCES Seg_User ([No])
GO

---------------------------------------------------------------------------------------------------------

IF OBJECT_ID(N'Cbtes_Aprobaciones','U') IS NULL
	CREATE TABLE Cbtes_Aprobaciones(
		Id_Cbte_Aprob	INT IDENTITY(1,1) NOT NULL,
		Id_Trans		INT NOT NULL,
		Id_Aprob_Rango  INT NOT NULL,
		Id_Usuario		SMALLINT NOT NULL,
		Fecha			DATETIME,
		Fecha_Proc		DATETIME,
		Estado			CHAR(1),  --{P|A|R}  Pendiente|Aprobado|Rechazado
		Nota			TEXT,
	 CONSTRAINT PK_CBTAP_PorID PRIMARY KEY CLUSTERED ( Id_Cbte_Aprob )
	)
GO

IF IndexProperty(Object_Id('Cbtes_Aprobaciones'), 'CBTAP_PorAus', 'IndexID') IS  NULL
	CREATE INDEX CBTAP_PorAus ON Cbtes_Aprobaciones (Id_Trans)
GO

IF OBJECT_ID('FK_CBTAP_Cbtes', 'F') IS NULL
	ALTER TABLE Cbtes_Aprobaciones  ADD  CONSTRAINT FK_CBTAP_Cbtes FOREIGN KEY(Id_Trans)
	REFERENCES Cbtes (Id_Trans)
GO


IF IndexProperty(Object_Id('Cbtes_Aprobaciones'), 'CBTAP_PorRan', 'IndexID') IS  NULL
	CREATE INDEX CBTAP_PorRan ON Cbtes_Aprobaciones (Id_Aprob_Rango)
GO

IF OBJECT_ID('FK_CBTAP_Cbtes', 'F') IS NULL
	ALTER TABLE Cbtes_Aprobaciones  ADD  CONSTRAINT FK_CBTAP_Cbtes FOREIGN KEY(Id_Aprob_Rango)
	REFERENCES Cbtes_Tipos_Aprob_Rangos (Id_Aprob_Rango)
GO
